/*********************************************************************/
/* Project Name: RGPIO.mcp                                           */
/* Source fle name: RGPIO.c                                          */
/*********************************************************************/
/* Copyright (C) 2007 Freescale Semiconductor, Inc.                  */
/* All Rights Reserved                                               */
/*********************************************************************/
/*********************************************************************/
/* Hands on training for QE128 MCU's                                 */
/* Module: RGPIO                                                     */
/* The firmware was developed on CodeWarrior 6.0 Alpha 2 version     */
/*                                                                   */
/* Description: This firmware shows how to configure the RGPIO       */
/* module on the V1 MCU.                                             */
/*********************************************************************/
/*                                                                   */
/* Date: 12/03/2007                                                  */
/* Ulises Corrales Salgado                                           */
/* Application Engineer                                              */
/* RTAC Americas                                                     */
/*********************************************************************/                                                                      


#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */

/*********************************************************************/
/*  Function declarations                                            */
/*********************************************************************/

void MCU_Init(void) {
  
 SOPT1 = 0x23;          /* Watchdog disable. Stop Mode Enable. Background Pin enable. RESET pin enable */  
}

void GPIO_Init(void) { 
  
  PTCDD = (byte) (PTCD | 0x3F);          /* Configure PTC0-PTC6 as outputs */
  PTEDD = (byte) (PTED | 0xC0);          /* Configure PTE port as output */
  PTCD = 0x3F;           /* Put 1's in PTC port in order to turn off the LEDs */
  PTED = 0xC0;           /* Put 1's in PTE port in order to turn off the LEDs */
}

void RGPIO_Init(void) { 
  
 RGPIO_DIR = 0x0080;          /* Configure PTE7 pin as output */
 RGPIO_ENB = 0x0080;          /* Configure PTE7 as RGPIO pin */
}


/*********************************************************************/
/*  Main Function                                                    */
/*********************************************************************/

void main(void) {

  MCU_Init();       /* Function that initializes the MCU */
  GPIO_Init();      /* Function that initializes the Ports of the MCU */
  RGPIO_Init();     /* Function that initializes the RGPIO module */
  
  EnableInterrupts; /* enable interrupts */
  
  for(;;) {

  PTCD_PTCD1 ^= 1;      /* Toggles a PTE1. This instruction is executed in 18 CPU cycles */
  PTCD ^= 0x01;         /* Toggles a PTE0. This instruction is executed in 5 CPU cycles */
  RGPIO_TOG = 0x0080;   /* Toggles PTE7. This instruction is executed in 2 CPU cycles */
  
  } /* loop forever */
  /* please make sure that you never leave this function */
}

